VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsHandlerChannel"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Sub addUserToListView(ByVal Index As Integer, ByVal Placement As Integer, ByVal Username As String, ByVal Ping As Long, ByVal Flags As Long, ByVal Client As String, ByVal ID_COLOR As Long, ByVal ICON_PRODUCT As Integer, ByVal Stats As String)
    Dim userPosition As Integer
    userPosition = findUserIndex(Username, frmMain.lvUsers)
    
    'Add to userlist array
    Call ProfileHandler(Index).UserListing.addUserChannel(Username, Ping, Flags, Client, ID_COLOR, ICON_PRODUCT, Stats)
    
    If (BotIndex = Index) Then
    
        'Check to see if user is in channel initially (Remove if so)
        If (userPosition > 0) Then
            Call frmMain.lvUsers.ListItems.Remove(userPosition)
        End If
        
        Dim Tag As String
        Tag = "Ping at logon: " & Ping & "ms" & vbNewLine & "Flags: " & Flags & vbNewLine & vbNewLine & MakeLongClientName(Client) & vbNewLine & "Stats: " & Stats
        
        'Add to real channel list
        Call addItemToListView(frmMain.lvUsers, Username, ICON_PRODUCT, _
                               getLagIcon(Ping, Flags), ID_COLOR, Tag, Placement)
    End If
End Sub

Public Sub addItemToListView(ByRef ListView As ListView, ByVal Username As String, ByVal ICON_SMALL As Long, ByVal ICON_REPORT As Long, ByVal ForeColor As Long, ByVal Tag As String, ByVal Placement As Integer)
    'Add item to listview
    If (Placement = 0) Then Placement = 1
    
    With ListView
        .ListItems.Add Placement, , Username, , ICON_SMALL
        If (ICON_REPORT <> 0) Then
            .ListItems(Placement).ListSubItems.Add , , , ICON_REPORT
        End If
        If (G_Options.Color_Code_Users) Then
            .ListItems(Placement).ForeColor = ForeColor
        End If
        .ListItems(Placement).Tag = Tag
    End With
End Sub

Public Function findUserIndex(ByVal Username As String, ByRef ListView As ListView) As Integer
On Error Resume Next
     With ListView
        findUserIndex = .FindItem(Username).Index
     End With
 End Function

Public Function getProductIcon(ByVal Product As String, ByVal Flags As Long) As Long
    If ((BNFLAGS_BLIZZ And Flags) = BNFLAGS_BLIZZ) Then
        getProductIcon = modIconConstants.ICON_BLIZZ
    ElseIf ((BNFLAGS_OP And Flags) = BNFLAGS_OP) Then
        getProductIcon = modIconConstants.ICON_GAVEL
    ElseIf ((BNFLAGS_SYSOP And Flags) = BNFLAGS_SYSOP) Then
        getProductIcon = modIconConstants.ICON_SYSOP
    ElseIf ((BNFLAGS_SQUELCH And Flags) = BNFLAGS_SQUELCH) Then
        getProductIcon = modIconConstants.ICON_SQUELCH
    ElseIf ((BNFLAGS_GLASSES And Flags) = BNFLAGS_GLASSES) Then
        getProductIcon = modIconConstants.ICON_GLASSES
    Else
        Select Case UCase(Product)
            Case "DRTL", "LTRD"
                getProductIcon = modIconConstants.ICON_DRTL
            Case "SSHR", "RHSS"
                getProductIcon = modIconConstants.ICON_SSHR
            Case "D2DV", "VD2D"
                getProductIcon = modIconConstants.ICON_D2DV
            Case "D2XP", "PX2D"
                getProductIcon = modIconConstants.ICON_D2XP
            Case "STAR", "RATS"
                getProductIcon = modIconConstants.ICON_STAR
            Case "SEXP", "PXES"
                getProductIcon = modIconConstants.ICON_SEXP
            Case "JSTR", "RTSJ"
                getProductIcon = modIconConstants.ICON_JSTR
            Case "W2BN", "NB2W"
                getProductIcon = modIconConstants.ICON_W2BN
            Case "3RAW", "WAR3"
                getProductIcon = modIconConstants.ICON_3RAW
            Case "W3XP", "PX3W"
                getProductIcon = modIconConstants.ICON_PX3W
            Case "RHSD", "DSHR"
                getProductIcon = modIconConstants.ICON_DSHR
            Case "CHAT", "TAHC"
                getProductIcon = modIconConstants.ICON_CHAT
            Case Else
                getProductIcon = modIconConstants.ICON_QUESTION
        End Select
    End If
End Function

Public Function getLagIcon(ByVal Ping As Long, ByVal Flags As Long) As Long
    If ((BNFLAGS_PLUG And Flags) = BNFLAGS_PLUG) Then
        getLagIcon = ICON_PLUG
    Else
        Select Case Ping
            Case -1
                getLagIcon = ICON_LAG_NEG
            Case 0
                getLagIcon = ICON_LAG_ZERO
            Case 1 To 200
                getLagIcon = ICON_LAG1
            Case 201 To 300
                getLagIcon = ICON_LAG2
            Case 301 To 400
                getLagIcon = ICON_LAG3
            Case 401 To 600
                getLagIcon = ICON_LAG4
            Case 601 To 1200
                getLagIcon = ICON_LAG5
            Case Else
                getLagIcon = ICON_LAG6
        End Select
    End If
End Function

Public Function MakeLongClientName(ByVal Client As String) As String
    Select Case UCase(Client)
        Case "DRTL", "LTRD"
            MakeLongClientName = "Diablo Retail"
        Case "SSHR", "RHSS"
            MakeLongClientName = "Starcraft Shareware"
        Case "D2DV", "VD2D"
            MakeLongClientName = "Diablo II"
        Case "D2XP", "PX2D"
            MakeLongClientName = "Diablo II: Lord of Destruction"
        Case "STAR", "RATS"
            MakeLongClientName = "Starcraft"
        Case "SEXP", "PXES"
            MakeLongClientName = "Starcraft: Brood War"
        Case "JSTR", "RTSJ"
            MakeLongClientName = "Starcraft Japan"
        Case "W2BN", "NB2W"
            MakeLongClientName = "Warcraft II"
        Case "3RAW", "WAR3"
            MakeLongClientName = "Warcraft III: Reign of Chaos"
        Case "RHSD", "DSHR"
            MakeLongClientName = "Diablo Shareware"
        Case "W3XP", "PX3W"
            MakeLongClientName = "Warcraft III: The Frozen Throne"
        Case "CHAT", "TAHC"
            MakeLongClientName = "CHAT"
        Case Else
            MakeLongClientName = "Unknown"
    End Select
End Function
